<?php
// @codingStandardsIgnoreStart

namespace Elementor;

class goto_count_down extends Widget_Base {

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_name() {
        return 'theme-countdown';
    }

    public function get_title() {
        return esc_html__( 'Countdown', 'goto' );
    }

    public function get_icon() {
        return 'eicon-countdown';
    }

    public function get_script_depends() {
        return array( 'jDoom-js' );
    }

    protected function register_controls() {
        $this->sectionGeneral();
        $this->sectionStyle();
    }

    private function sectionGeneral(){
        $this->start_controls_section( 'section_countdown', array(
            'label' =>  esc_html__( 'Countdown', 'goto' ),
        ));

        $this->add_control( 'date', array(
            'label' =>  esc_html__( 'Due Date', 'goto' ),
            'type'  =>  Controls_Manager::DATE_TIME,
            'picker_options' => array(
                'enableTime' => false,
                'dateFormat' => 'm/d/Y',
            ),
            'default' => '10/23/2020'
        ));

        $this->add_control(
            'day_text',
            [
                'label'         =>  esc_html__( 'Text Days', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'days', 'goto' ),
            ]
        );

        $this->add_control(
            'hours_text',
            [
                'label'         =>  esc_html__( 'Text Hours', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'hours', 'goto' ),
            ]
        );

        $this->add_control(
            'mins_text',
            [
                'label'         =>  esc_html__( 'Text Mins', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'mins', 'goto' ),
            ]
        );

        $this->add_control(
            'seconds_text',
            [
                'label'         =>  esc_html__( 'Text Seconds', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'seconds', 'goto' ),
            ]
        );

        $this->end_controls_section();
    }

    private function sectionStyle(){
        $this->start_controls_section( 'section_box_style', array(
            'label' => esc_html__( 'Boxes', 'goto' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        ));

        $this->add_control( 'head_align', array(
            'label' => esc_html__( 'Align', 'goto' ),
            'type'  => Controls_Manager::HEADING,
        ));

        $this->add_responsive_control( 'align', array(
            'type'    => Controls_Manager::CHOOSE,
            'label'   => esc_html__( 'Alignment', 'goto' ),
            'options' => array(
                'left' => array(
                    'title' => esc_html__( 'Left', 'goto' ),
                    'icon'  => 'fa fa-align-left'
                ),
                'center' => array(
                    'title' => esc_html__( 'Center', 'goto' ),
                    'icon'  => 'fa fa-align-center'
                ),
                'right' => array(
                    'title' => esc_html__( 'Right', 'goto' ),
                    'icon'  => 'fa fa-align-right'
                ),
            ),
            'default'        => 'center',
            'tablet_default' => 'center',
            'mobile_default' => 'center',
            'selectors'      => array(
                '{{WRAPPER}} .wd-countdown' => 'text-align: {{VALUE}};'
            ),
        ));

        $this->add_control(
            'heading_digits',
            [
                'label' => esc_html__( 'Digits', 'goto' ),
                'type'  => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'digits_color',
            [
                'label'     => esc_html__( 'Color', 'goto' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wdcd-time' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'digits_typography',
                'selector' => '{{WRAPPER}} .wdcd-time',
            ]
        );

        $this->add_control(
            'heading_label',
            [
                'label'     => esc_html__( 'Label', 'goto' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label'     => esc_html__( 'Color', 'goto' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wdcd-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'label_typography',
                'selector' => '{{WRAPPER}} .wdcd-text',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->renderCountdown();
        ?>

        <div class="site-coming-soon__countdown">
            <div class="wd-countdown" data-date="<?php echo esc_attr( $settings['date'] ); ?>">
                <div class="wd-countdown-item">
                    <span id="<?php echo esc_attr( uniqid( 'wdcd-days-' ) ); ?>" class="wdcd-time">20</span>
                    <span class="wdcd-text"><?php echo esc_html( $settings['day_text'] ); ?></span>
                </div>

                <div class="wd-countdown-item">
                    <span id="<?php echo esc_attr( uniqid( 'wdcd-hours-' ) ); ?>" class="wdcd-time">20</span>
                    <span class="wdcd-text"><?php echo esc_html( $settings['hours_text'] ); ?></span>
                </div>

                <div class="wd-countdown-item">
                    <span id="<?php echo esc_attr( uniqid( 'wdcd-minutes-' ) ); ?>" class="wdcd-time">12</span>
                    <span class="wdcd-text"><?php echo esc_html( $settings['mins_text'] ); ?></span>
                </div>

                <div class="wd-countdown-item">
                    <span id="<?php echo esc_attr( uniqid( 'wdcd-seconds-' ) ); ?>" class="wdcd-time">32</span>
                    <span class="wdcd-text"><?php echo esc_html( $settings['seconds_text'] ); ?></span>
                </div>
            </div>
        </div>
    <?php
    }

    protected function renderCountdown(){
        wp_enqueue_script( 'jDoom-js' );
        wp_add_inline_script(
            'jDoom-js',
            "document.addEventListener( 'DOMContentLoaded', function(){
                var el = document.getElementsByClassName( 'wd-countdown' ),
                    elen = el.length,
                    i;
                if( elen < 1 ) return;

                for( i = 0; i < elen; i++ ){
                    var _date = el[i].getAttribute( 'data-date' ),
                        days_id = el[i].getElementsByClassName( 'wdcd-time' )[0].id,
                        hours_id = el[i].getElementsByClassName( 'wdcd-time' )[1].id,
                        mins_id = el[i].getElementsByClassName( 'wdcd-time' )[2].id,
                        secs_id = el[i].getElementsByClassName( 'wdcd-time' )[3].id;

                    var counter = Doom( {
                        targetDate: _date,
                        ids: {
                            days: days_id,
                            hours: hours_id,
                            mins: mins_id,
                            secs: secs_id,
                        },
                    } );

                    counter.doom();
                }
            } );",
            'after'
        );
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new goto_count_down() );